# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .i18n_names import I18nNames
from .restricted_mode_setting import RestrictedModeSetting


class UpdateChatRequestBody(object):
    _types = {
        "avatar": str,
        "name": str,
        "description": str,
        "i18n_names": I18nNames,
        "add_member_permission": str,
        "share_card_permission": str,
        "at_all_permission": str,
        "edit_permission": str,
        "owner_id": str,
        "join_message_visibility": str,
        "leave_message_visibility": str,
        "membership_approval": str,
        "restricted_mode_setting": RestrictedModeSetting,
        "chat_type": str,
        "group_message_type": str,
        "urgent_setting": str,
        "video_conference_setting": str,
    }

    def __init__(self, d=None):
        self.avatar: Optional[str] = None
        self.name: Optional[str] = None
        self.description: Optional[str] = None
        self.i18n_names: Optional[I18nNames] = None
        self.add_member_permission: Optional[str] = None
        self.share_card_permission: Optional[str] = None
        self.at_all_permission: Optional[str] = None
        self.edit_permission: Optional[str] = None
        self.owner_id: Optional[str] = None
        self.join_message_visibility: Optional[str] = None
        self.leave_message_visibility: Optional[str] = None
        self.membership_approval: Optional[str] = None
        self.restricted_mode_setting: Optional[RestrictedModeSetting] = None
        self.chat_type: Optional[str] = None
        self.group_message_type: Optional[str] = None
        self.urgent_setting: Optional[str] = None
        self.video_conference_setting: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "UpdateChatRequestBodyBuilder":
        return UpdateChatRequestBodyBuilder()


class UpdateChatRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._update_chat_request_body = UpdateChatRequestBody()

    def avatar(self, avatar: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.avatar = avatar
        return self

    def name(self, name: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.name = name
        return self

    def description(self, description: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.description = description
        return self

    def i18n_names(self, i18n_names: I18nNames) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.i18n_names = i18n_names
        return self

    def add_member_permission(self, add_member_permission: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.add_member_permission = add_member_permission
        return self

    def share_card_permission(self, share_card_permission: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.share_card_permission = share_card_permission
        return self

    def at_all_permission(self, at_all_permission: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.at_all_permission = at_all_permission
        return self

    def edit_permission(self, edit_permission: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.edit_permission = edit_permission
        return self

    def owner_id(self, owner_id: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.owner_id = owner_id
        return self

    def join_message_visibility(self, join_message_visibility: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.join_message_visibility = join_message_visibility
        return self

    def leave_message_visibility(self, leave_message_visibility: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.leave_message_visibility = leave_message_visibility
        return self

    def membership_approval(self, membership_approval: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.membership_approval = membership_approval
        return self

    def restricted_mode_setting(self, restricted_mode_setting: RestrictedModeSetting) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.restricted_mode_setting = restricted_mode_setting
        return self

    def chat_type(self, chat_type: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.chat_type = chat_type
        return self

    def group_message_type(self, group_message_type: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.group_message_type = group_message_type
        return self

    def urgent_setting(self, urgent_setting: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.urgent_setting = urgent_setting
        return self

    def video_conference_setting(self, video_conference_setting: str) -> "UpdateChatRequestBodyBuilder":
        self._update_chat_request_body.video_conference_setting = video_conference_setting
        return self

    def build(self) -> "UpdateChatRequestBody":
        return self._update_chat_request_body
