# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .update_message_request_body import UpdateMessageRequestBody


class UpdateMessageRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.message_id: Optional[str] = None
        self.request_body: Optional[UpdateMessageRequestBody] = None

    @staticmethod
    def builder() -> "UpdateMessageRequestBuilder":
        return UpdateMessageRequestBuilder()


class UpdateMessageRequestBuilder(object):

    def __init__(self) -> None:
        update_message_request = UpdateMessageRequest()
        update_message_request.http_method = HttpMethod.PUT
        update_message_request.uri = "/open-apis/im/v1/messages/:message_id"
        update_message_request.token_types = {AccessTokenType.TENANT}
        self._update_message_request: UpdateMessageRequest = update_message_request

    def message_id(self, message_id: str) -> "UpdateMessageRequestBuilder":
        self._update_message_request.message_id = message_id
        self._update_message_request.paths["message_id"] = str(message_id)
        return self

    def request_body(self, request_body: UpdateMessageRequestBody) -> "UpdateMessageRequestBuilder":
        self._update_message_request.request_body = request_body
        self._update_message_request.body = request_body
        return self

    def build(self) -> UpdateMessageRequest:
        return self._update_message_request
