# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .update_tabs_chat_tab_request_body import UpdateTabsChatTabRequestBody


class UpdateTabsChatTabRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.chat_id: Optional[str] = None
        self.request_body: Optional[UpdateTabsChatTabRequestBody] = None

    @staticmethod
    def builder() -> "UpdateTabsChatTabRequestBuilder":
        return UpdateTabsChatTabRequestBuilder()


class UpdateTabsChatTabRequestBuilder(object):

    def __init__(self) -> None:
        update_tabs_chat_tab_request = UpdateTabsChatTabRequest()
        update_tabs_chat_tab_request.http_method = HttpMethod.POST
        update_tabs_chat_tab_request.uri = "/open-apis/im/v1/chats/:chat_id/chat_tabs/update_tabs"
        update_tabs_chat_tab_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._update_tabs_chat_tab_request: UpdateTabsChatTabRequest = update_tabs_chat_tab_request

    def chat_id(self, chat_id: str) -> "UpdateTabsChatTabRequestBuilder":
        self._update_tabs_chat_tab_request.chat_id = chat_id
        self._update_tabs_chat_tab_request.paths["chat_id"] = str(chat_id)
        return self

    def request_body(self, request_body: UpdateTabsChatTabRequestBody) -> "UpdateTabsChatTabRequestBuilder":
        self._update_tabs_chat_tab_request.request_body = request_body
        self._update_tabs_chat_tab_request.body = request_body
        return self

    def build(self) -> UpdateTabsChatTabRequest:
        return self._update_tabs_chat_tab_request
