# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_chat_request import CreateChatRequest
from ..model.create_chat_response import CreateChatResponse
from ..model.delete_chat_request import DeleteChatRequest
from ..model.delete_chat_response import DeleteChatResponse
from ..model.get_chat_request import GetChatRequest
from ..model.get_chat_response import GetChatResponse
from ..model.link_chat_request import LinkChatRequest
from ..model.link_chat_response import LinkChatResponse
from ..model.list_chat_request import ListChatRequest
from ..model.list_chat_response import ListChatResponse
from ..model.search_chat_request import SearchChatRequest
from ..model.search_chat_response import SearchChatResponse
from ..model.update_chat_request import UpdateChatRequest
from ..model.update_chat_response import UpdateChatResponse


class Chat(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateChatRequest, option: Optional[RequestOption] = None) -> CreateChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateChatResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateChatResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateChatRequest, option: Optional[RequestOption] = None) -> CreateChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateChatResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateChatResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteChatRequest, option: Optional[RequestOption] = None) -> DeleteChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteChatResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteChatResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteChatRequest, option: Optional[RequestOption] = None) -> DeleteChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteChatResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteChatResponse)
        response.raw = resp

        return response

    def get(self, request: GetChatRequest, option: Optional[RequestOption] = None) -> GetChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetChatResponse = JSON.unmarshal(str(resp.content, UTF_8), GetChatResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetChatRequest, option: Optional[RequestOption] = None) -> GetChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetChatResponse = JSON.unmarshal(str(resp.content, UTF_8), GetChatResponse)
        response.raw = resp

        return response

    def link(self, request: LinkChatRequest, option: Optional[RequestOption] = None) -> LinkChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: LinkChatResponse = JSON.unmarshal(str(resp.content, UTF_8), LinkChatResponse)
        response.raw = resp

        return response

    async def alink(self, request: LinkChatRequest, option: Optional[RequestOption] = None) -> LinkChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: LinkChatResponse = JSON.unmarshal(str(resp.content, UTF_8), LinkChatResponse)
        response.raw = resp

        return response

    def list(self, request: ListChatRequest, option: Optional[RequestOption] = None) -> ListChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListChatResponse = JSON.unmarshal(str(resp.content, UTF_8), ListChatResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListChatRequest, option: Optional[RequestOption] = None) -> ListChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListChatResponse = JSON.unmarshal(str(resp.content, UTF_8), ListChatResponse)
        response.raw = resp

        return response

    def search(self, request: SearchChatRequest, option: Optional[RequestOption] = None) -> SearchChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SearchChatResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchChatResponse)
        response.raw = resp

        return response

    async def asearch(self, request: SearchChatRequest, option: Optional[RequestOption] = None) -> SearchChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SearchChatResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchChatResponse)
        response.raw = resp

        return response

    def update(self, request: UpdateChatRequest, option: Optional[RequestOption] = None) -> UpdateChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateChatResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateChatResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdateChatRequest, option: Optional[RequestOption] = None) -> UpdateChatResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateChatResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateChatResponse)
        response.raw = resp

        return response
