# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.add_managers_chat_managers_request import AddManagersChatManagersRequest
from ..model.add_managers_chat_managers_response import AddManagersChatManagersResponse
from ..model.delete_managers_chat_managers_request import DeleteManagersChatManagersRequest
from ..model.delete_managers_chat_managers_response import DeleteManagersChatManagersResponse


class ChatManagers(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def add_managers(self, request: AddManagersChatManagersRequest,
                     option: Optional[RequestOption] = None) -> AddManagersChatManagersResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: AddManagersChatManagersResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   AddManagersChatManagersResponse)
        response.raw = resp

        return response

    async def aadd_managers(self, request: AddManagersChatManagersRequest,
                            option: Optional[RequestOption] = None) -> AddManagersChatManagersResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: AddManagersChatManagersResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   AddManagersChatManagersResponse)
        response.raw = resp

        return response

    def delete_managers(self, request: DeleteManagersChatManagersRequest,
                        option: Optional[RequestOption] = None) -> DeleteManagersChatManagersResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteManagersChatManagersResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      DeleteManagersChatManagersResponse)
        response.raw = resp

        return response

    async def adelete_managers(self, request: DeleteManagersChatManagersRequest,
                               option: Optional[RequestOption] = None) -> DeleteManagersChatManagersResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteManagersChatManagersResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      DeleteManagersChatManagersResponse)
        response.raw = resp

        return response
