# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_chat_tab_request import CreateChatTabRequest
from ..model.create_chat_tab_response import CreateChatTabResponse
from ..model.delete_tabs_chat_tab_request import DeleteTabsChatTabRequest
from ..model.delete_tabs_chat_tab_response import DeleteTabsChatTabResponse
from ..model.list_tabs_chat_tab_request import ListTabsChatTabRequest
from ..model.list_tabs_chat_tab_response import ListTabsChatTabResponse
from ..model.sort_tabs_chat_tab_request import SortTabsChatTabRequest
from ..model.sort_tabs_chat_tab_response import SortTabsChatTabResponse
from ..model.update_tabs_chat_tab_request import UpdateTabsChatTabRequest
from ..model.update_tabs_chat_tab_response import UpdateTabsChatTabResponse


class ChatTab(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateChatTabRequest, option: Optional[RequestOption] = None) -> CreateChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateChatTabResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateChatTabRequest,
                      option: Optional[RequestOption] = None) -> CreateChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateChatTabResponse)
        response.raw = resp

        return response

    def delete_tabs(self, request: DeleteTabsChatTabRequest,
                    option: Optional[RequestOption] = None) -> DeleteTabsChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteTabsChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteTabsChatTabResponse)
        response.raw = resp

        return response

    async def adelete_tabs(self, request: DeleteTabsChatTabRequest,
                           option: Optional[RequestOption] = None) -> DeleteTabsChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteTabsChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteTabsChatTabResponse)
        response.raw = resp

        return response

    def list_tabs(self, request: ListTabsChatTabRequest,
                  option: Optional[RequestOption] = None) -> ListTabsChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListTabsChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTabsChatTabResponse)
        response.raw = resp

        return response

    async def alist_tabs(self, request: ListTabsChatTabRequest,
                         option: Optional[RequestOption] = None) -> ListTabsChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListTabsChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), ListTabsChatTabResponse)
        response.raw = resp

        return response

    def sort_tabs(self, request: SortTabsChatTabRequest,
                  option: Optional[RequestOption] = None) -> SortTabsChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SortTabsChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), SortTabsChatTabResponse)
        response.raw = resp

        return response

    async def asort_tabs(self, request: SortTabsChatTabRequest,
                         option: Optional[RequestOption] = None) -> SortTabsChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SortTabsChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), SortTabsChatTabResponse)
        response.raw = resp

        return response

    def update_tabs(self, request: UpdateTabsChatTabRequest,
                    option: Optional[RequestOption] = None) -> UpdateTabsChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdateTabsChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateTabsChatTabResponse)
        response.raw = resp

        return response

    async def aupdate_tabs(self, request: UpdateTabsChatTabRequest,
                           option: Optional[RequestOption] = None) -> UpdateTabsChatTabResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdateTabsChatTabResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdateTabsChatTabResponse)
        response.raw = resp

        return response
