# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.delete_top_notice_chat_top_notice_request import DeleteTopNoticeChatTopNoticeRequest
from ..model.delete_top_notice_chat_top_notice_response import DeleteTopNoticeChatTopNoticeResponse
from ..model.put_top_notice_chat_top_notice_request import PutTopNoticeChatTopNoticeRequest
from ..model.put_top_notice_chat_top_notice_response import PutTopNoticeChatTopNoticeResponse


class ChatTopNotice(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def delete_top_notice(self, request: DeleteTopNoticeChatTopNoticeRequest,
                          option: Optional[RequestOption] = None) -> DeleteTopNoticeChatTopNoticeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteTopNoticeChatTopNoticeResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        DeleteTopNoticeChatTopNoticeResponse)
        response.raw = resp

        return response

    async def adelete_top_notice(self, request: DeleteTopNoticeChatTopNoticeRequest,
                                 option: Optional[RequestOption] = None) -> DeleteTopNoticeChatTopNoticeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteTopNoticeChatTopNoticeResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                        DeleteTopNoticeChatTopNoticeResponse)
        response.raw = resp

        return response

    def put_top_notice(self, request: PutTopNoticeChatTopNoticeRequest,
                       option: Optional[RequestOption] = None) -> PutTopNoticeChatTopNoticeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PutTopNoticeChatTopNoticeResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     PutTopNoticeChatTopNoticeResponse)
        response.raw = resp

        return response

    async def aput_top_notice(self, request: PutTopNoticeChatTopNoticeRequest,
                              option: Optional[RequestOption] = None) -> PutTopNoticeChatTopNoticeResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PutTopNoticeChatTopNoticeResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     PutTopNoticeChatTopNoticeResponse)
        response.raw = resp

        return response
