# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .doc_bullet import DocBullet
from .doc_code import DocCode
from .doc_container import DocContainer
from .doc_divider import DocDivider
from .doc_heading import DocHeading
from .doc_image import DocImage
from .doc_link import DocLink
from .doc_rodered import DocRodered
from .doc_text import DocText
from .doc_user import DocUser


class DocContent(object):
    _types = {
        "id": str,
        "children": List[str],
        "content_type": int,
        "text": DocText,
        "heading": DocHeading,
        "bullet": DocBullet,
        "ordered": DocRodered,
        "code": DocCode,
        "link": DocLink,
        "image": DocImage,
        "user": DocUser,
        "divider": DocDivider,
        "container": DocContainer,
    }

    def __init__(self, d=None):
        self.id: Optional[str] = None
        self.children: Optional[List[str]] = None
        self.content_type: Optional[int] = None
        self.text: Optional[DocText] = None
        self.heading: Optional[DocHeading] = None
        self.bullet: Optional[DocBullet] = None
        self.ordered: Optional[DocRodered] = None
        self.code: Optional[DocCode] = None
        self.link: Optional[DocLink] = None
        self.image: Optional[DocImage] = None
        self.user: Optional[DocUser] = None
        self.divider: Optional[DocDivider] = None
        self.container: Optional[DocContainer] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DocContentBuilder":
        return DocContentBuilder()


class DocContentBuilder(object):
    def __init__(self) -> None:
        self._doc_content = DocContent()

    def id(self, id: str) -> "DocContentBuilder":
        self._doc_content.id = id
        return self

    def children(self, children: List[str]) -> "DocContentBuilder":
        self._doc_content.children = children
        return self

    def content_type(self, content_type: int) -> "DocContentBuilder":
        self._doc_content.content_type = content_type
        return self

    def text(self, text: DocText) -> "DocContentBuilder":
        self._doc_content.text = text
        return self

    def heading(self, heading: DocHeading) -> "DocContentBuilder":
        self._doc_content.heading = heading
        return self

    def bullet(self, bullet: DocBullet) -> "DocContentBuilder":
        self._doc_content.bullet = bullet
        return self

    def ordered(self, ordered: DocRodered) -> "DocContentBuilder":
        self._doc_content.ordered = ordered
        return self

    def code(self, code: DocCode) -> "DocContentBuilder":
        self._doc_content.code = code
        return self

    def link(self, link: DocLink) -> "DocContentBuilder":
        self._doc_content.link = link
        return self

    def image(self, image: DocImage) -> "DocContentBuilder":
        self._doc_content.image = image
        return self

    def user(self, user: DocUser) -> "DocContentBuilder":
        self._doc_content.user = user
        return self

    def divider(self, divider: DocDivider) -> "DocContentBuilder":
        self._doc_content.divider = divider
        return self

    def container(self, container: DocContainer) -> "DocContentBuilder":
        self._doc_content.container = container
        return self

    def build(self) -> "DocContent":
        return self._doc_content
