# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .doc_content import DocContent


class DocData(object):
    _types = {
        "doc_token": str,
        "created_at": int,
        "updated_at": int,
        "doc_contents": List[DocContent],
        "root_content_id": str,
    }

    def __init__(self, d=None):
        self.doc_token: Optional[str] = None
        self.created_at: Optional[int] = None
        self.updated_at: Optional[int] = None
        self.doc_contents: Optional[List[DocContent]] = None
        self.root_content_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DocDataBuilder":
        return DocDataBuilder()


class DocDataBuilder(object):
    def __init__(self) -> None:
        self._doc_data = DocData()

    def doc_token(self, doc_token: str) -> "DocDataBuilder":
        self._doc_data.doc_token = doc_token
        return self

    def created_at(self, created_at: int) -> "DocDataBuilder":
        self._doc_data.created_at = created_at
        return self

    def updated_at(self, updated_at: int) -> "DocDataBuilder":
        self._doc_data.updated_at = updated_at
        return self

    def doc_contents(self, doc_contents: List[DocContent]) -> "DocDataBuilder":
        self._doc_data.doc_contents = doc_contents
        return self

    def root_content_id(self, root_content_id: str) -> "DocDataBuilder":
        self._doc_data.root_content_id = root_content_id
        return self

    def build(self) -> "DocData":
        return self._doc_data
