# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .entity import Entity


class Draft(object):
    _types = {
        "draft_id": int,
        "entity": Entity,
    }

    def __init__(self, d=None):
        self.draft_id: Optional[int] = None
        self.entity: Optional[Entity] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DraftBuilder":
        return DraftBuilder()


class DraftBuilder(object):
    def __init__(self) -> None:
        self._draft = Draft()

    def draft_id(self, draft_id: int) -> "DraftBuilder":
        self._draft.draft_id = draft_id
        return self

    def entity(self, entity: Entity) -> "DraftBuilder":
        self._draft.entity = entity
        return self

    def build(self) -> "Draft":
        return self._draft
