# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class I18nEntryDesc(object):
    _types = {
        "language": int,
        "description": str,
        "rich_text": str,
    }

    def __init__(self, d=None):
        self.language: Optional[int] = None
        self.description: Optional[str] = None
        self.rich_text: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "I18nEntryDescBuilder":
        return I18nEntryDescBuilder()


class I18nEntryDescBuilder(object):
    def __init__(self) -> None:
        self._i18n_entry_desc = I18nEntryDesc()

    def language(self, language: int) -> "I18nEntryDescBuilder":
        self._i18n_entry_desc.language = language
        return self

    def description(self, description: str) -> "I18nEntryDescBuilder":
        self._i18n_entry_desc.description = description
        return self

    def rich_text(self, rich_text: str) -> "I18nEntryDescBuilder":
        self._i18n_entry_desc.rich_text = rich_text
        return self

    def build(self) -> "I18nEntryDesc":
        return self._i18n_entry_desc
