# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class OuterInfo(object):
    _types = {
        "provider": str,
        "outer_id": str,
    }

    def __init__(self, d=None):
        self.provider: Optional[str] = None
        self.outer_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "OuterInfoBuilder":
        return OuterInfoBuilder()


class OuterInfoBuilder(object):
    def __init__(self) -> None:
        self._outer_info = OuterInfo()

    def provider(self, provider: str) -> "OuterInfoBuilder":
        self._outer_info.provider = provider
        return self

    def outer_id(self, outer_id: str) -> "OuterInfoBuilder":
        self._outer_info.outer_id = outer_id
        return self

    def build(self) -> "OuterInfo":
        return self._outer_info
