# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .correct_info import CorrectInfo
from .word_info import WordInfo


class StatisticalReport(object):
    _types = {
        "date_interval": int,
        "word_info": WordInfo,
        "correct_info": CorrectInfo,
        "update_date": int,
    }

    def __init__(self, d=None):
        self.date_interval: Optional[int] = None
        self.word_info: Optional[WordInfo] = None
        self.correct_info: Optional[CorrectInfo] = None
        self.update_date: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "StatisticalReportBuilder":
        return StatisticalReportBuilder()


class StatisticalReportBuilder(object):
    def __init__(self) -> None:
        self._statistical_report = StatisticalReport()

    def date_interval(self, date_interval: int) -> "StatisticalReportBuilder":
        self._statistical_report.date_interval = date_interval
        return self

    def word_info(self, word_info: WordInfo) -> "StatisticalReportBuilder":
        self._statistical_report.word_info = word_info
        return self

    def correct_info(self, correct_info: CorrectInfo) -> "StatisticalReportBuilder":
        self._statistical_report.correct_info = correct_info
        return self

    def update_date(self, update_date: int) -> "StatisticalReportBuilder":
        self._statistical_report.update_date = update_date
        return self

    def build(self) -> "StatisticalReport":
        return self._statistical_report
