# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .entity import Entity


class UpdateEntityRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.entity_id: Optional[str] = None
        self.request_body: Optional[Entity] = None

    @staticmethod
    def builder() -> "UpdateEntityRequestBuilder":
        return UpdateEntityRequestBuilder()


class UpdateEntityRequestBuilder(object):

    def __init__(self) -> None:
        update_entity_request = UpdateEntityRequest()
        update_entity_request.http_method = HttpMethod.PUT
        update_entity_request.uri = "/open-apis/lingo/v1/entities/:entity_id"
        update_entity_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._update_entity_request: UpdateEntityRequest = update_entity_request

    def user_id_type(self, user_id_type: str) -> "UpdateEntityRequestBuilder":
        self._update_entity_request.user_id_type = user_id_type
        self._update_entity_request.add_query("user_id_type", user_id_type)
        return self

    def entity_id(self, entity_id: str) -> "UpdateEntityRequestBuilder":
        self._update_entity_request.entity_id = entity_id
        self._update_entity_request.paths["entity_id"] = str(entity_id)
        return self

    def request_body(self, request_body: Entity) -> "UpdateEntityRequestBuilder":
        self._update_entity_request.request_body = request_body
        self._update_entity_request.body = request_body
        return self

    def build(self) -> UpdateEntityRequest:
        return self._update_entity_request
