# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .file import File


class UploadFileRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[File] = None

    @staticmethod
    def builder() -> "UploadFileRequestBuilder":
        return UploadFileRequestBuilder()


class UploadFileRequestBuilder(object):

    def __init__(self) -> None:
        upload_file_request = UploadFileRequest()
        upload_file_request.http_method = HttpMethod.POST
        upload_file_request.uri = "/open-apis/lingo/v1/files/upload"
        upload_file_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._upload_file_request: UploadFileRequest = upload_file_request

    def request_body(self, request_body: File) -> "UploadFileRequestBuilder":
        self._upload_file_request.request_body = request_body
        self._upload_file_request.body = request_body
        return self

    def build(self) -> UploadFileRequest:
        return self._upload_file_request
