# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AttachmentDownloadUrlItem(object):
    _types = {
        "attachment_id": str,
        "download_url": str,
    }

    def __init__(self, d=None):
        self.attachment_id: Optional[str] = None
        self.download_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AttachmentDownloadUrlItemBuilder":
        return AttachmentDownloadUrlItemBuilder()


class AttachmentDownloadUrlItemBuilder(object):
    def __init__(self) -> None:
        self._attachment_download_url_item = AttachmentDownloadUrlItem()

    def attachment_id(self, attachment_id: str) -> "AttachmentDownloadUrlItemBuilder":
        self._attachment_download_url_item.attachment_id = attachment_id
        return self

    def download_url(self, download_url: str) -> "AttachmentDownloadUrlItemBuilder":
        self._attachment_download_url_item.download_url = download_url
        return self

    def build(self) -> "AttachmentDownloadUrlItem":
        return self._attachment_download_url_item
