# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .batch_delete_mailgroup_permission_member_request_body import BatchDeleteMailgroupPermissionMemberRequestBody


class BatchDeleteMailgroupPermissionMemberRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.mailgroup_id: Optional[str] = None
        self.request_body: Optional[BatchDeleteMailgroupPermissionMemberRequestBody] = None

    @staticmethod
    def builder() -> "BatchDeleteMailgroupPermissionMemberRequestBuilder":
        return BatchDeleteMailgroupPermissionMemberRequestBuilder()


class BatchDeleteMailgroupPermissionMemberRequestBuilder(object):

    def __init__(self) -> None:
        batch_delete_mailgroup_permission_member_request = BatchDeleteMailgroupPermissionMemberRequest()
        batch_delete_mailgroup_permission_member_request.http_method = HttpMethod.DELETE
        batch_delete_mailgroup_permission_member_request.uri = "/open-apis/mail/v1/mailgroups/:mailgroup_id/permission_members/batch_delete"
        batch_delete_mailgroup_permission_member_request.token_types = {AccessTokenType.TENANT}
        self._batch_delete_mailgroup_permission_member_request: BatchDeleteMailgroupPermissionMemberRequest = batch_delete_mailgroup_permission_member_request

    def mailgroup_id(self, mailgroup_id: str) -> "BatchDeleteMailgroupPermissionMemberRequestBuilder":
        self._batch_delete_mailgroup_permission_member_request.mailgroup_id = mailgroup_id
        self._batch_delete_mailgroup_permission_member_request.paths["mailgroup_id"] = str(mailgroup_id)
        return self

    def request_body(self,
                     request_body: BatchDeleteMailgroupPermissionMemberRequestBody) -> "BatchDeleteMailgroupPermissionMemberRequestBuilder":
        self._batch_delete_mailgroup_permission_member_request.request_body = request_body
        self._batch_delete_mailgroup_permission_member_request.body = request_body
        return self

    def build(self) -> BatchDeleteMailgroupPermissionMemberRequest:
        return self._batch_delete_mailgroup_permission_member_request
