# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .public_mailbox import PublicMailbox


class CreatePublicMailboxRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[PublicMailbox] = None

    @staticmethod
    def builder() -> "CreatePublicMailboxRequestBuilder":
        return CreatePublicMailboxRequestBuilder()


class CreatePublicMailboxRequestBuilder(object):

    def __init__(self) -> None:
        create_public_mailbox_request = CreatePublicMailboxRequest()
        create_public_mailbox_request.http_method = HttpMethod.POST
        create_public_mailbox_request.uri = "/open-apis/mail/v1/public_mailboxes"
        create_public_mailbox_request.token_types = {AccessTokenType.TENANT}
        self._create_public_mailbox_request: CreatePublicMailboxRequest = create_public_mailbox_request

    def request_body(self, request_body: PublicMailbox) -> "CreatePublicMailboxRequestBuilder":
        self._create_public_mailbox_request.request_body = request_body
        self._create_public_mailbox_request.body = request_body
        return self

    def build(self) -> CreatePublicMailboxRequest:
        return self._create_public_mailbox_request
