# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .email_alias import EmailAlias


class CreateUserMailboxAliasRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_mailbox_id: Optional[str] = None
        self.request_body: Optional[EmailAlias] = None

    @staticmethod
    def builder() -> "CreateUserMailboxAliasRequestBuilder":
        return CreateUserMailboxAliasRequestBuilder()


class CreateUserMailboxAliasRequestBuilder(object):

    def __init__(self) -> None:
        create_user_mailbox_alias_request = CreateUserMailboxAliasRequest()
        create_user_mailbox_alias_request.http_method = HttpMethod.POST
        create_user_mailbox_alias_request.uri = "/open-apis/mail/v1/user_mailboxes/:user_mailbox_id/aliases"
        create_user_mailbox_alias_request.token_types = {AccessTokenType.TENANT}
        self._create_user_mailbox_alias_request: CreateUserMailboxAliasRequest = create_user_mailbox_alias_request

    def user_mailbox_id(self, user_mailbox_id: str) -> "CreateUserMailboxAliasRequestBuilder":
        self._create_user_mailbox_alias_request.user_mailbox_id = user_mailbox_id
        self._create_user_mailbox_alias_request.paths["user_mailbox_id"] = str(user_mailbox_id)
        return self

    def request_body(self, request_body: EmailAlias) -> "CreateUserMailboxAliasRequestBuilder":
        self._create_user_mailbox_alias_request.request_body = request_body
        self._create_user_mailbox_alias_request.body = request_body
        return self

    def build(self) -> CreateUserMailboxAliasRequest:
        return self._create_user_mailbox_alias_request
