# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .mailgroup_manager import MailgroupManager


class ListMailgroupManagerResponseBody(object):
    _types = {
        "items": List[MailgroupManager],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[MailgroupManager]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ListMailgroupManagerResponseBodyBuilder":
        return ListMailgroupManagerResponseBodyBuilder()


class ListMailgroupManagerResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._list_mailgroup_manager_response_body = ListMailgroupManagerResponseBody()

    def items(self, items: List[MailgroupManager]) -> "ListMailgroupManagerResponseBodyBuilder":
        self._list_mailgroup_manager_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "ListMailgroupManagerResponseBodyBuilder":
        self._list_mailgroup_manager_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "ListMailgroupManagerResponseBodyBuilder":
        self._list_mailgroup_manager_response_body.has_more = has_more
        return self

    def build(self) -> "ListMailgroupManagerResponseBody":
        return self._list_mailgroup_manager_response_body
