# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListMailgroupRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.manager_user_id: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None

    @staticmethod
    def builder() -> "ListMailgroupRequestBuilder":
        return ListMailgroupRequestBuilder()


class ListMailgroupRequestBuilder(object):

    def __init__(self) -> None:
        list_mailgroup_request = ListMailgroupRequest()
        list_mailgroup_request.http_method = HttpMethod.GET
        list_mailgroup_request.uri = "/open-apis/mail/v1/mailgroups"
        list_mailgroup_request.token_types = {AccessTokenType.TENANT}
        self._list_mailgroup_request: ListMailgroupRequest = list_mailgroup_request

    def manager_user_id(self, manager_user_id: str) -> "ListMailgroupRequestBuilder":
        self._list_mailgroup_request.manager_user_id = manager_user_id
        self._list_mailgroup_request.add_query("manager_user_id", manager_user_id)
        return self

    def user_id_type(self, user_id_type: str) -> "ListMailgroupRequestBuilder":
        self._list_mailgroup_request.user_id_type = user_id_type
        self._list_mailgroup_request.add_query("user_id_type", user_id_type)
        return self

    def page_token(self, page_token: str) -> "ListMailgroupRequestBuilder":
        self._list_mailgroup_request.page_token = page_token
        self._list_mailgroup_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "ListMailgroupRequestBuilder":
        self._list_mailgroup_request.page_size = page_size
        self._list_mailgroup_request.add_query("page_size", page_size)
        return self

    def build(self) -> ListMailgroupRequest:
        return self._list_mailgroup_request
