# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListPublicMailboxAliasRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.public_mailbox_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListPublicMailboxAliasRequestBuilder":
        return ListPublicMailboxAliasRequestBuilder()


class ListPublicMailboxAliasRequestBuilder(object):

    def __init__(self) -> None:
        list_public_mailbox_alias_request = ListPublicMailboxAliasRequest()
        list_public_mailbox_alias_request.http_method = HttpMethod.GET
        list_public_mailbox_alias_request.uri = "/open-apis/mail/v1/public_mailboxes/:public_mailbox_id/aliases"
        list_public_mailbox_alias_request.token_types = {AccessTokenType.TENANT}
        self._list_public_mailbox_alias_request: ListPublicMailboxAliasRequest = list_public_mailbox_alias_request

    def public_mailbox_id(self, public_mailbox_id: str) -> "ListPublicMailboxAliasRequestBuilder":
        self._list_public_mailbox_alias_request.public_mailbox_id = public_mailbox_id
        self._list_public_mailbox_alias_request.paths["public_mailbox_id"] = str(public_mailbox_id)
        return self

    def build(self) -> ListPublicMailboxAliasRequest:
        return self._list_public_mailbox_alias_request
