# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListUserMailboxAliasRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_token: Optional[str] = None
        self.page_size: Optional[int] = None
        self.user_mailbox_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListUserMailboxAliasRequestBuilder":
        return ListUserMailboxAliasRequestBuilder()


class ListUserMailboxAliasRequestBuilder(object):

    def __init__(self) -> None:
        list_user_mailbox_alias_request = ListUserMailboxAliasRequest()
        list_user_mailbox_alias_request.http_method = HttpMethod.GET
        list_user_mailbox_alias_request.uri = "/open-apis/mail/v1/user_mailboxes/:user_mailbox_id/aliases"
        list_user_mailbox_alias_request.token_types = {AccessTokenType.TENANT}
        self._list_user_mailbox_alias_request: ListUserMailboxAliasRequest = list_user_mailbox_alias_request

    def page_token(self, page_token: str) -> "ListUserMailboxAliasRequestBuilder":
        self._list_user_mailbox_alias_request.page_token = page_token
        self._list_user_mailbox_alias_request.add_query("page_token", page_token)
        return self

    def page_size(self, page_size: int) -> "ListUserMailboxAliasRequestBuilder":
        self._list_user_mailbox_alias_request.page_size = page_size
        self._list_user_mailbox_alias_request.add_query("page_size", page_size)
        return self

    def user_mailbox_id(self, user_mailbox_id: str) -> "ListUserMailboxAliasRequestBuilder":
        self._list_user_mailbox_alias_request.user_mailbox_id = user_mailbox_id
        self._list_user_mailbox_alias_request.paths["user_mailbox_id"] = str(user_mailbox_id)
        return self

    def build(self) -> ListUserMailboxAliasRequest:
        return self._list_user_mailbox_alias_request
