# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MailgroupMember(object):
    _types = {
        "member_id": str,
        "email": str,
        "user_id": str,
        "department_id": str,
        "type": str,
    }

    def __init__(self, d=None):
        self.member_id: Optional[str] = None
        self.email: Optional[str] = None
        self.user_id: Optional[str] = None
        self.department_id: Optional[str] = None
        self.type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MailgroupMemberBuilder":
        return MailgroupMemberBuilder()


class MailgroupMemberBuilder(object):
    def __init__(self) -> None:
        self._mailgroup_member = MailgroupMember()

    def member_id(self, member_id: str) -> "MailgroupMemberBuilder":
        self._mailgroup_member.member_id = member_id
        return self

    def email(self, email: str) -> "MailgroupMemberBuilder":
        self._mailgroup_member.email = email
        return self

    def user_id(self, user_id: str) -> "MailgroupMemberBuilder":
        self._mailgroup_member.user_id = user_id
        return self

    def department_id(self, department_id: str) -> "MailgroupMemberBuilder":
        self._mailgroup_member.department_id = department_id
        return self

    def type(self, type: str) -> "MailgroupMemberBuilder":
        self._mailgroup_member.type = type
        return self

    def build(self) -> "MailgroupMember":
        return self._mailgroup_member
