# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class MailgroupPermissionMember(object):
    _types = {
        "permission_member_id": str,
        "user_id": str,
        "department_id": str,
        "email": str,
        "type": str,
    }

    def __init__(self, d=None):
        self.permission_member_id: Optional[str] = None
        self.user_id: Optional[str] = None
        self.department_id: Optional[str] = None
        self.email: Optional[str] = None
        self.type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "MailgroupPermissionMemberBuilder":
        return MailgroupPermissionMemberBuilder()


class MailgroupPermissionMemberBuilder(object):
    def __init__(self) -> None:
        self._mailgroup_permission_member = MailgroupPermissionMember()

    def permission_member_id(self, permission_member_id: str) -> "MailgroupPermissionMemberBuilder":
        self._mailgroup_permission_member.permission_member_id = permission_member_id
        return self

    def user_id(self, user_id: str) -> "MailgroupPermissionMemberBuilder":
        self._mailgroup_permission_member.user_id = user_id
        return self

    def department_id(self, department_id: str) -> "MailgroupPermissionMemberBuilder":
        self._mailgroup_permission_member.department_id = department_id
        return self

    def email(self, email: str) -> "MailgroupPermissionMemberBuilder":
        self._mailgroup_permission_member.email = email
        return self

    def type(self, type: str) -> "MailgroupPermissionMemberBuilder":
        self._mailgroup_permission_member.type = type
        return self

    def build(self) -> "MailgroupPermissionMember":
        return self._mailgroup_permission_member
