# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .query_user_request_body import QueryUserRequestBody


class QueryUserRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[QueryUserRequestBody] = None

    @staticmethod
    def builder() -> "QueryUserRequestBuilder":
        return QueryUserRequestBuilder()


class QueryUserRequestBuilder(object):

    def __init__(self) -> None:
        query_user_request = QueryUserRequest()
        query_user_request.http_method = HttpMethod.POST
        query_user_request.uri = "/open-apis/mail/v1/users/query"
        query_user_request.token_types = {AccessTokenType.TENANT}
        self._query_user_request: QueryUserRequest = query_user_request

    def request_body(self, request_body: QueryUserRequestBody) -> "QueryUserRequestBuilder":
        self._query_user_request.request_body = request_body
        self._query_user_request.body = request_body
        return self

    def build(self) -> QueryUserRequest:
        return self._query_user_request
