# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .rule_action import RuleAction
from .rule_condition import RuleCondition


class Rule(object):
    _types = {
        "id": int,
        "condition": RuleCondition,
        "action": RuleAction,
        "ignore_the_rest_of_rules": bool,
        "name": str,
        "is_enable": bool,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.condition: Optional[RuleCondition] = None
        self.action: Optional[RuleAction] = None
        self.ignore_the_rest_of_rules: Optional[bool] = None
        self.name: Optional[str] = None
        self.is_enable: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "RuleBuilder":
        return RuleBuilder()


class RuleBuilder(object):
    def __init__(self) -> None:
        self._rule = Rule()

    def id(self, id: int) -> "RuleBuilder":
        self._rule.id = id
        return self

    def condition(self, condition: RuleCondition) -> "RuleBuilder":
        self._rule.condition = condition
        return self

    def action(self, action: RuleAction) -> "RuleBuilder":
        self._rule.action = action
        return self

    def ignore_the_rest_of_rules(self, ignore_the_rest_of_rules: bool) -> "RuleBuilder":
        self._rule.ignore_the_rest_of_rules = ignore_the_rest_of_rules
        return self

    def name(self, name: str) -> "RuleBuilder":
        self._rule.name = name
        return self

    def is_enable(self, is_enable: bool) -> "RuleBuilder":
        self._rule.is_enable = is_enable
        return self

    def build(self) -> "Rule":
        return self._rule
