# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .rule_condition_item import RuleConditionItem


class RuleCondition(object):
    _types = {
        "match_type": int,
        "items": List[RuleConditionItem],
    }

    def __init__(self, d=None):
        self.match_type: Optional[int] = None
        self.items: Optional[List[RuleConditionItem]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "RuleConditionBuilder":
        return RuleConditionBuilder()


class RuleConditionBuilder(object):
    def __init__(self) -> None:
        self._rule_condition = RuleCondition()

    def match_type(self, match_type: int) -> "RuleConditionBuilder":
        self._rule_condition.match_type = match_type
        return self

    def items(self, items: List[RuleConditionItem]) -> "RuleConditionBuilder":
        self._rule_condition.items = items
        return self

    def build(self) -> "RuleCondition":
        return self._rule_condition
