# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .mailgroup import Mailgroup


class UpdateMailgroupRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.mailgroup_id: Optional[str] = None
        self.request_body: Optional[Mailgroup] = None

    @staticmethod
    def builder() -> "UpdateMailgroupRequestBuilder":
        return UpdateMailgroupRequestBuilder()


class UpdateMailgroupRequestBuilder(object):

    def __init__(self) -> None:
        update_mailgroup_request = UpdateMailgroupRequest()
        update_mailgroup_request.http_method = HttpMethod.PUT
        update_mailgroup_request.uri = "/open-apis/mail/v1/mailgroups/:mailgroup_id"
        update_mailgroup_request.token_types = {AccessTokenType.TENANT}
        self._update_mailgroup_request: UpdateMailgroupRequest = update_mailgroup_request

    def mailgroup_id(self, mailgroup_id: str) -> "UpdateMailgroupRequestBuilder":
        self._update_mailgroup_request.mailgroup_id = mailgroup_id
        self._update_mailgroup_request.paths["mailgroup_id"] = str(mailgroup_id)
        return self

    def request_body(self, request_body: Mailgroup) -> "UpdateMailgroupRequestBuilder":
        self._update_mailgroup_request.request_body = request_body
        self._update_mailgroup_request.body = request_body
        return self

    def build(self) -> UpdateMailgroupRequest:
        return self._update_mailgroup_request
