# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.batch_create_mailgroup_manager_request import BatchCreateMailgroupManagerRequest
from ..model.batch_create_mailgroup_manager_response import BatchCreateMailgroupManagerResponse
from ..model.batch_delete_mailgroup_manager_request import BatchDeleteMailgroupManagerRequest
from ..model.batch_delete_mailgroup_manager_response import BatchDeleteMailgroupManagerResponse
from ..model.list_mailgroup_manager_request import ListMailgroupManagerRequest
from ..model.list_mailgroup_manager_response import ListMailgroupManagerResponse


class MailgroupManager(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def batch_create(self, request: BatchCreateMailgroupManagerRequest,
                     option: Optional[RequestOption] = None) -> BatchCreateMailgroupManagerResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchCreateMailgroupManagerResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       BatchCreateMailgroupManagerResponse)
        response.raw = resp

        return response

    async def abatch_create(self, request: BatchCreateMailgroupManagerRequest,
                            option: Optional[RequestOption] = None) -> BatchCreateMailgroupManagerResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchCreateMailgroupManagerResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       BatchCreateMailgroupManagerResponse)
        response.raw = resp

        return response

    def batch_delete(self, request: BatchDeleteMailgroupManagerRequest,
                     option: Optional[RequestOption] = None) -> BatchDeleteMailgroupManagerResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchDeleteMailgroupManagerResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       BatchDeleteMailgroupManagerResponse)
        response.raw = resp

        return response

    async def abatch_delete(self, request: BatchDeleteMailgroupManagerRequest,
                            option: Optional[RequestOption] = None) -> BatchDeleteMailgroupManagerResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchDeleteMailgroupManagerResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                       BatchDeleteMailgroupManagerResponse)
        response.raw = resp

        return response

    def list(self, request: ListMailgroupManagerRequest,
             option: Optional[RequestOption] = None) -> ListMailgroupManagerResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListMailgroupManagerResponse = JSON.unmarshal(str(resp.content, UTF_8), ListMailgroupManagerResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListMailgroupManagerRequest,
                    option: Optional[RequestOption] = None) -> ListMailgroupManagerResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListMailgroupManagerResponse = JSON.unmarshal(str(resp.content, UTF_8), ListMailgroupManagerResponse)
        response.raw = resp

        return response
