# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_public_mailbox_request import CreatePublicMailboxRequest
from ..model.create_public_mailbox_response import CreatePublicMailboxResponse
from ..model.delete_public_mailbox_request import DeletePublicMailboxRequest
from ..model.delete_public_mailbox_response import DeletePublicMailboxResponse
from ..model.get_public_mailbox_request import GetPublicMailboxRequest
from ..model.get_public_mailbox_response import GetPublicMailboxResponse
from ..model.list_public_mailbox_request import ListPublicMailboxRequest
from ..model.list_public_mailbox_response import ListPublicMailboxResponse
from ..model.patch_public_mailbox_request import PatchPublicMailboxRequest
from ..model.patch_public_mailbox_response import PatchPublicMailboxResponse
from ..model.update_public_mailbox_request import UpdatePublicMailboxRequest
from ..model.update_public_mailbox_response import UpdatePublicMailboxResponse


class PublicMailbox(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreatePublicMailboxRequest,
               option: Optional[RequestOption] = None) -> CreatePublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreatePublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), CreatePublicMailboxResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreatePublicMailboxRequest,
                      option: Optional[RequestOption] = None) -> CreatePublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreatePublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), CreatePublicMailboxResponse)
        response.raw = resp

        return response

    def delete(self, request: DeletePublicMailboxRequest,
               option: Optional[RequestOption] = None) -> DeletePublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeletePublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), DeletePublicMailboxResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeletePublicMailboxRequest,
                      option: Optional[RequestOption] = None) -> DeletePublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeletePublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), DeletePublicMailboxResponse)
        response.raw = resp

        return response

    def get(self, request: GetPublicMailboxRequest, option: Optional[RequestOption] = None) -> GetPublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetPublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), GetPublicMailboxResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetPublicMailboxRequest,
                   option: Optional[RequestOption] = None) -> GetPublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetPublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), GetPublicMailboxResponse)
        response.raw = resp

        return response

    def list(self, request: ListPublicMailboxRequest,
             option: Optional[RequestOption] = None) -> ListPublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListPublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), ListPublicMailboxResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListPublicMailboxRequest,
                    option: Optional[RequestOption] = None) -> ListPublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListPublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), ListPublicMailboxResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchPublicMailboxRequest,
              option: Optional[RequestOption] = None) -> PatchPublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchPublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchPublicMailboxResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchPublicMailboxRequest,
                     option: Optional[RequestOption] = None) -> PatchPublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchPublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchPublicMailboxResponse)
        response.raw = resp

        return response

    def update(self, request: UpdatePublicMailboxRequest,
               option: Optional[RequestOption] = None) -> UpdatePublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UpdatePublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdatePublicMailboxResponse)
        response.raw = resp

        return response

    async def aupdate(self, request: UpdatePublicMailboxRequest,
                      option: Optional[RequestOption] = None) -> UpdatePublicMailboxResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UpdatePublicMailboxResponse = JSON.unmarshal(str(resp.content, UTF_8), UpdatePublicMailboxResponse)
        response.raw = resp

        return response
