# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.batch_create_public_mailbox_member_request import BatchCreatePublicMailboxMemberRequest
from ..model.batch_create_public_mailbox_member_response import BatchCreatePublicMailboxMemberResponse
from ..model.batch_delete_public_mailbox_member_request import BatchDeletePublicMailboxMemberRequest
from ..model.batch_delete_public_mailbox_member_response import BatchDeletePublicMailboxMemberResponse
from ..model.clear_public_mailbox_member_request import ClearPublicMailboxMemberRequest
from ..model.clear_public_mailbox_member_response import ClearPublicMailboxMemberResponse
from ..model.create_public_mailbox_member_request import CreatePublicMailboxMemberRequest
from ..model.create_public_mailbox_member_response import CreatePublicMailboxMemberResponse
from ..model.delete_public_mailbox_member_request import DeletePublicMailboxMemberRequest
from ..model.delete_public_mailbox_member_response import DeletePublicMailboxMemberResponse
from ..model.get_public_mailbox_member_request import GetPublicMailboxMemberRequest
from ..model.get_public_mailbox_member_response import GetPublicMailboxMemberResponse
from ..model.list_public_mailbox_member_request import ListPublicMailboxMemberRequest
from ..model.list_public_mailbox_member_response import ListPublicMailboxMemberResponse


class PublicMailboxMember(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def batch_create(self, request: BatchCreatePublicMailboxMemberRequest,
                     option: Optional[RequestOption] = None) -> BatchCreatePublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchCreatePublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                          BatchCreatePublicMailboxMemberResponse)
        response.raw = resp

        return response

    async def abatch_create(self, request: BatchCreatePublicMailboxMemberRequest,
                            option: Optional[RequestOption] = None) -> BatchCreatePublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchCreatePublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                          BatchCreatePublicMailboxMemberResponse)
        response.raw = resp

        return response

    def batch_delete(self, request: BatchDeletePublicMailboxMemberRequest,
                     option: Optional[RequestOption] = None) -> BatchDeletePublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BatchDeletePublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                          BatchDeletePublicMailboxMemberResponse)
        response.raw = resp

        return response

    async def abatch_delete(self, request: BatchDeletePublicMailboxMemberRequest,
                            option: Optional[RequestOption] = None) -> BatchDeletePublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BatchDeletePublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                          BatchDeletePublicMailboxMemberResponse)
        response.raw = resp

        return response

    def clear(self, request: ClearPublicMailboxMemberRequest,
              option: Optional[RequestOption] = None) -> ClearPublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ClearPublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    ClearPublicMailboxMemberResponse)
        response.raw = resp

        return response

    async def aclear(self, request: ClearPublicMailboxMemberRequest,
                     option: Optional[RequestOption] = None) -> ClearPublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ClearPublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    ClearPublicMailboxMemberResponse)
        response.raw = resp

        return response

    def create(self, request: CreatePublicMailboxMemberRequest,
               option: Optional[RequestOption] = None) -> CreatePublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreatePublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     CreatePublicMailboxMemberResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreatePublicMailboxMemberRequest,
                      option: Optional[RequestOption] = None) -> CreatePublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreatePublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     CreatePublicMailboxMemberResponse)
        response.raw = resp

        return response

    def delete(self, request: DeletePublicMailboxMemberRequest,
               option: Optional[RequestOption] = None) -> DeletePublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeletePublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     DeletePublicMailboxMemberResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeletePublicMailboxMemberRequest,
                      option: Optional[RequestOption] = None) -> DeletePublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeletePublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                     DeletePublicMailboxMemberResponse)
        response.raw = resp

        return response

    def get(self, request: GetPublicMailboxMemberRequest,
            option: Optional[RequestOption] = None) -> GetPublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetPublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  GetPublicMailboxMemberResponse)
        response.raw = resp

        return response

    async def aget(self, request: GetPublicMailboxMemberRequest,
                   option: Optional[RequestOption] = None) -> GetPublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetPublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  GetPublicMailboxMemberResponse)
        response.raw = resp

        return response

    def list(self, request: ListPublicMailboxMemberRequest,
             option: Optional[RequestOption] = None) -> ListPublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListPublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   ListPublicMailboxMemberResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListPublicMailboxMemberRequest,
                    option: Optional[RequestOption] = None) -> ListPublicMailboxMemberResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListPublicMailboxMemberResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   ListPublicMailboxMemberResponse)
        response.raw = resp

        return response
