# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Appendix(object):
    _types = {
        "file_id": str,
        "file_name": str,
        "file_type": str,
        "file_size": int,
        "download_url": str,
    }

    def __init__(self, d=None):
        self.file_id: Optional[str] = None
        self.file_name: Optional[str] = None
        self.file_type: Optional[str] = None
        self.file_size: Optional[int] = None
        self.download_url: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AppendixBuilder":
        return AppendixBuilder()


class AppendixBuilder(object):
    def __init__(self) -> None:
        self._appendix = Appendix()

    def file_id(self, file_id: str) -> "AppendixBuilder":
        self._appendix.file_id = file_id
        return self

    def file_name(self, file_name: str) -> "AppendixBuilder":
        self._appendix.file_name = file_name
        return self

    def file_type(self, file_type: str) -> "AppendixBuilder":
        self._appendix.file_type = file_type
        return self

    def file_size(self, file_size: int) -> "AppendixBuilder":
        self._appendix.file_size = file_size
        return self

    def download_url(self, download_url: str) -> "AppendixBuilder":
        self._appendix.download_url = download_url
        return self

    def build(self) -> "Appendix":
        return self._appendix
