# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class CompanyAsset(object):
    _types = {
        "asset_uid": str,
        "asset_sub_no": str,
        "asset_type": str,
        "asset_type_name": str,
        "asset_name": str,
        "quantity": int,
        "unit": str,
        "company_uid": str,
        "asset_type_name_en": str,
        "asset_no": str,
    }

    def __init__(self, d=None):
        self.asset_uid: Optional[str] = None
        self.asset_sub_no: Optional[str] = None
        self.asset_type: Optional[str] = None
        self.asset_type_name: Optional[str] = None
        self.asset_name: Optional[str] = None
        self.quantity: Optional[int] = None
        self.unit: Optional[str] = None
        self.company_uid: Optional[str] = None
        self.asset_type_name_en: Optional[str] = None
        self.asset_no: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CompanyAssetBuilder":
        return CompanyAssetBuilder()


class CompanyAssetBuilder(object):
    def __init__(self) -> None:
        self._company_asset = CompanyAsset()

    def asset_uid(self, asset_uid: str) -> "CompanyAssetBuilder":
        self._company_asset.asset_uid = asset_uid
        return self

    def asset_sub_no(self, asset_sub_no: str) -> "CompanyAssetBuilder":
        self._company_asset.asset_sub_no = asset_sub_no
        return self

    def asset_type(self, asset_type: str) -> "CompanyAssetBuilder":
        self._company_asset.asset_type = asset_type
        return self

    def asset_type_name(self, asset_type_name: str) -> "CompanyAssetBuilder":
        self._company_asset.asset_type_name = asset_type_name
        return self

    def asset_name(self, asset_name: str) -> "CompanyAssetBuilder":
        self._company_asset.asset_name = asset_name
        return self

    def quantity(self, quantity: int) -> "CompanyAssetBuilder":
        self._company_asset.quantity = quantity
        return self

    def unit(self, unit: str) -> "CompanyAssetBuilder":
        self._company_asset.unit = unit
        return self

    def company_uid(self, company_uid: str) -> "CompanyAssetBuilder":
        self._company_asset.company_uid = company_uid
        return self

    def asset_type_name_en(self, asset_type_name_en: str) -> "CompanyAssetBuilder":
        self._company_asset.asset_type_name_en = asset_type_name_en
        return self

    def asset_no(self, asset_no: str) -> "CompanyAssetBuilder":
        self._company_asset.asset_no = asset_no
        return self

    def build(self) -> "CompanyAsset":
        return self._company_asset
