# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n_struct import I18nStruct


class CostCenter(object):
    _types = {
        "cost_center_uid": str,
        "cost_center_code": str,
        "i18n_cost_center_name": List[I18nStruct],
        "responsible_user_union_id": str,
        "co_area_code": str,
        "profit_center_code": str,
        "business_area": str,
        "fee_type": str,
        "valid_to": str,
        "cost_center_name": str,
        "company_code_list": List[str],
    }

    def __init__(self, d=None):
        self.cost_center_uid: Optional[str] = None
        self.cost_center_code: Optional[str] = None
        self.i18n_cost_center_name: Optional[List[I18nStruct]] = None
        self.responsible_user_union_id: Optional[str] = None
        self.co_area_code: Optional[str] = None
        self.profit_center_code: Optional[str] = None
        self.business_area: Optional[str] = None
        self.fee_type: Optional[str] = None
        self.valid_to: Optional[str] = None
        self.cost_center_name: Optional[str] = None
        self.company_code_list: Optional[List[str]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CostCenterBuilder":
        return CostCenterBuilder()


class CostCenterBuilder(object):
    def __init__(self) -> None:
        self._cost_center = CostCenter()

    def cost_center_uid(self, cost_center_uid: str) -> "CostCenterBuilder":
        self._cost_center.cost_center_uid = cost_center_uid
        return self

    def cost_center_code(self, cost_center_code: str) -> "CostCenterBuilder":
        self._cost_center.cost_center_code = cost_center_code
        return self

    def i18n_cost_center_name(self, i18n_cost_center_name: List[I18nStruct]) -> "CostCenterBuilder":
        self._cost_center.i18n_cost_center_name = i18n_cost_center_name
        return self

    def responsible_user_union_id(self, responsible_user_union_id: str) -> "CostCenterBuilder":
        self._cost_center.responsible_user_union_id = responsible_user_union_id
        return self

    def co_area_code(self, co_area_code: str) -> "CostCenterBuilder":
        self._cost_center.co_area_code = co_area_code
        return self

    def profit_center_code(self, profit_center_code: str) -> "CostCenterBuilder":
        self._cost_center.profit_center_code = profit_center_code
        return self

    def business_area(self, business_area: str) -> "CostCenterBuilder":
        self._cost_center.business_area = business_area
        return self

    def fee_type(self, fee_type: str) -> "CostCenterBuilder":
        self._cost_center.fee_type = fee_type
        return self

    def valid_to(self, valid_to: str) -> "CostCenterBuilder":
        self._cost_center.valid_to = valid_to
        return self

    def cost_center_name(self, cost_center_name: str) -> "CostCenterBuilder":
        self._cost_center.cost_center_name = cost_center_name
        return self

    def company_code_list(self, company_code_list: List[str]) -> "CostCenterBuilder":
        self._cost_center.company_code_list = company_code_list
        return self

    def build(self) -> "CostCenter":
        return self._cost_center
