# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .appendix import Appendix


class ExtendField(object):
    _types = {
        "field_type": int,
        "field_value": str,
        "options": List[str],
        "num": float,
        "date": str,
        "range_date": List[str],
        "field_code": str,
        "appendix": List[Appendix],
    }

    def __init__(self, d=None):
        self.field_type: Optional[int] = None
        self.field_value: Optional[str] = None
        self.options: Optional[List[str]] = None
        self.num: Optional[float] = None
        self.date: Optional[str] = None
        self.range_date: Optional[List[str]] = None
        self.field_code: Optional[str] = None
        self.appendix: Optional[List[Appendix]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ExtendFieldBuilder":
        return ExtendFieldBuilder()


class ExtendFieldBuilder(object):
    def __init__(self) -> None:
        self._extend_field = ExtendField()

    def field_type(self, field_type: int) -> "ExtendFieldBuilder":
        self._extend_field.field_type = field_type
        return self

    def field_value(self, field_value: str) -> "ExtendFieldBuilder":
        self._extend_field.field_value = field_value
        return self

    def options(self, options: List[str]) -> "ExtendFieldBuilder":
        self._extend_field.options = options
        return self

    def num(self, num: float) -> "ExtendFieldBuilder":
        self._extend_field.num = num
        return self

    def date(self, date: str) -> "ExtendFieldBuilder":
        self._extend_field.date = date
        return self

    def range_date(self, range_date: List[str]) -> "ExtendFieldBuilder":
        self._extend_field.range_date = range_date
        return self

    def field_code(self, field_code: str) -> "ExtendFieldBuilder":
        self._extend_field.field_code = field_code
        return self

    def appendix(self, appendix: List[Appendix]) -> "ExtendFieldBuilder":
        self._extend_field.appendix = appendix
        return self

    def build(self) -> "ExtendField":
        return self._extend_field
