# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .user_auth_data_relation import UserAuthDataRelation


class UnbindUserAuthDataRelationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[UserAuthDataRelation] = None

    @staticmethod
    def builder() -> "UnbindUserAuthDataRelationRequestBuilder":
        return UnbindUserAuthDataRelationRequestBuilder()


class UnbindUserAuthDataRelationRequestBuilder(object):

    def __init__(self) -> None:
        unbind_user_auth_data_relation_request = UnbindUserAuthDataRelationRequest()
        unbind_user_auth_data_relation_request.http_method = HttpMethod.POST
        unbind_user_auth_data_relation_request.uri = "/open-apis/mdm/v1/user_auth_data_relations/unbind"
        unbind_user_auth_data_relation_request.token_types = {AccessTokenType.TENANT}
        self._unbind_user_auth_data_relation_request: UnbindUserAuthDataRelationRequest = unbind_user_auth_data_relation_request

    def user_id_type(self, user_id_type: str) -> "UnbindUserAuthDataRelationRequestBuilder":
        self._unbind_user_auth_data_relation_request.user_id_type = user_id_type
        self._unbind_user_auth_data_relation_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: UserAuthDataRelation) -> "UnbindUserAuthDataRelationRequestBuilder":
        self._unbind_user_auth_data_relation_request.request_body = request_body
        self._unbind_user_auth_data_relation_request.body = request_body
        return self

    def build(self) -> UnbindUserAuthDataRelationRequest:
        return self._unbind_user_auth_data_relation_request
