# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .extend_field import ExtendField


class VendorAccount(object):
    _types = {
        "id": int,
        "account": str,
        "iban": str,
        "account_name": str,
        "bank_id": str,
        "bank_code": str,
        "swift_code": str,
        "vendor_site_code": str,
        "bank_name": str,
        "bank_acronym": str,
        "country": str,
        "bank_control_code": str,
        "extend_info": List[ExtendField],
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.account: Optional[str] = None
        self.iban: Optional[str] = None
        self.account_name: Optional[str] = None
        self.bank_id: Optional[str] = None
        self.bank_code: Optional[str] = None
        self.swift_code: Optional[str] = None
        self.vendor_site_code: Optional[str] = None
        self.bank_name: Optional[str] = None
        self.bank_acronym: Optional[str] = None
        self.country: Optional[str] = None
        self.bank_control_code: Optional[str] = None
        self.extend_info: Optional[List[ExtendField]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "VendorAccountBuilder":
        return VendorAccountBuilder()


class VendorAccountBuilder(object):
    def __init__(self) -> None:
        self._vendor_account = VendorAccount()

    def id(self, id: int) -> "VendorAccountBuilder":
        self._vendor_account.id = id
        return self

    def account(self, account: str) -> "VendorAccountBuilder":
        self._vendor_account.account = account
        return self

    def iban(self, iban: str) -> "VendorAccountBuilder":
        self._vendor_account.iban = iban
        return self

    def account_name(self, account_name: str) -> "VendorAccountBuilder":
        self._vendor_account.account_name = account_name
        return self

    def bank_id(self, bank_id: str) -> "VendorAccountBuilder":
        self._vendor_account.bank_id = bank_id
        return self

    def bank_code(self, bank_code: str) -> "VendorAccountBuilder":
        self._vendor_account.bank_code = bank_code
        return self

    def swift_code(self, swift_code: str) -> "VendorAccountBuilder":
        self._vendor_account.swift_code = swift_code
        return self

    def vendor_site_code(self, vendor_site_code: str) -> "VendorAccountBuilder":
        self._vendor_account.vendor_site_code = vendor_site_code
        return self

    def bank_name(self, bank_name: str) -> "VendorAccountBuilder":
        self._vendor_account.bank_name = bank_name
        return self

    def bank_acronym(self, bank_acronym: str) -> "VendorAccountBuilder":
        self._vendor_account.bank_acronym = bank_acronym
        return self

    def country(self, country: str) -> "VendorAccountBuilder":
        self._vendor_account.country = country
        return self

    def bank_control_code(self, bank_control_code: str) -> "VendorAccountBuilder":
        self._vendor_account.bank_control_code = bank_control_code
        return self

    def extend_info(self, extend_info: List[ExtendField]) -> "VendorAccountBuilder":
        self._vendor_account.extend_info = extend_info
        return self

    def build(self) -> "VendorAccount":
        return self._vendor_account
