# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .extend_field import ExtendField


class VendorContact(object):
    _types = {
        "id": int,
        "name": str,
        "position": str,
        "email": str,
        "phone": str,
        "remark": str,
        "extend_info": List[ExtendField],
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.name: Optional[str] = None
        self.position: Optional[str] = None
        self.email: Optional[str] = None
        self.phone: Optional[str] = None
        self.remark: Optional[str] = None
        self.extend_info: Optional[List[ExtendField]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "VendorContactBuilder":
        return VendorContactBuilder()


class VendorContactBuilder(object):
    def __init__(self) -> None:
        self._vendor_contact = VendorContact()

    def id(self, id: int) -> "VendorContactBuilder":
        self._vendor_contact.id = id
        return self

    def name(self, name: str) -> "VendorContactBuilder":
        self._vendor_contact.name = name
        return self

    def position(self, position: str) -> "VendorContactBuilder":
        self._vendor_contact.position = position
        return self

    def email(self, email: str) -> "VendorContactBuilder":
        self._vendor_contact.email = email
        return self

    def phone(self, phone: str) -> "VendorContactBuilder":
        self._vendor_contact.phone = phone
        return self

    def remark(self, remark: str) -> "VendorContactBuilder":
        self._vendor_contact.remark = remark
        return self

    def extend_info(self, extend_info: List[ExtendField]) -> "VendorContactBuilder":
        self._vendor_contact.extend_info = extend_info
        return self

    def build(self) -> "VendorContact":
        return self._vendor_contact
