# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.bind_user_auth_data_relation_request import BindUserAuthDataRelationRequest
from ..model.bind_user_auth_data_relation_response import BindUserAuthDataRelationResponse
from ..model.unbind_user_auth_data_relation_request import UnbindUserAuthDataRelationRequest
from ..model.unbind_user_auth_data_relation_response import UnbindUserAuthDataRelationResponse


class UserAuthDataRelation(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def bind(self, request: BindUserAuthDataRelationRequest,
             option: Optional[RequestOption] = None) -> BindUserAuthDataRelationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: BindUserAuthDataRelationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    BindUserAuthDataRelationResponse)
        response.raw = resp

        return response

    async def abind(self, request: BindUserAuthDataRelationRequest,
                    option: Optional[RequestOption] = None) -> BindUserAuthDataRelationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: BindUserAuthDataRelationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                    BindUserAuthDataRelationResponse)
        response.raw = resp

        return response

    def unbind(self, request: UnbindUserAuthDataRelationRequest,
               option: Optional[RequestOption] = None) -> UnbindUserAuthDataRelationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: UnbindUserAuthDataRelationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      UnbindUserAuthDataRelationResponse)
        response.raw = resp

        return response

    async def aunbind(self, request: UnbindUserAuthDataRelationRequest,
                      option: Optional[RequestOption] = None) -> UnbindUserAuthDataRelationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: UnbindUserAuthDataRelationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                      UnbindUserAuthDataRelationResponse)
        response.raw = resp

        return response
