# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .vchat import Vchat


class EventInfo(object):
    _types = {
        "uid": str,
        "original_time": int,
        "summary": str,
        "vchat": List[Vchat],
    }

    def __init__(self, d=None):
        self.uid: Optional[str] = None
        self.original_time: Optional[int] = None
        self.summary: Optional[str] = None
        self.vchat: Optional[List[Vchat]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "EventInfoBuilder":
        return EventInfoBuilder()


class EventInfoBuilder(object):
    def __init__(self) -> None:
        self._event_info = EventInfo()

    def uid(self, uid: str) -> "EventInfoBuilder":
        self._event_info.uid = uid
        return self

    def original_time(self, original_time: int) -> "EventInfoBuilder":
        self._event_info.original_time = original_time
        return self

    def summary(self, summary: str) -> "EventInfoBuilder":
        self._event_info.summary = summary
        return self

    def vchat(self, vchat: List[Vchat]) -> "EventInfoBuilder":
        self._event_info.vchat = vchat
        return self

    def build(self) -> "EventInfo":
        return self._event_info
