# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class AlignObjective(object):
    _types = {
        "id": int,
        "okr_id": int,
        "user_id": str,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.okr_id: Optional[int] = None
        self.user_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "AlignObjectiveBuilder":
        return AlignObjectiveBuilder()


class AlignObjectiveBuilder(object):
    def __init__(self) -> None:
        self._align_objective = AlignObjective()

    def id(self, id: int) -> "AlignObjectiveBuilder":
        self._align_objective.id = id
        return self

    def okr_id(self, okr_id: int) -> "AlignObjectiveBuilder":
        self._align_objective.okr_id = okr_id
        return self

    def user_id(self, user_id: str) -> "AlignObjectiveBuilder":
        self._align_objective.user_id = user_id
        return self

    def build(self) -> "AlignObjective":
        return self._align_objective
