# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class BatchGetOkrRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.okr_ids: Optional[List[str]] = None
        self.lang: Optional[str] = None

    @staticmethod
    def builder() -> "BatchGetOkrRequestBuilder":
        return BatchGetOkrRequestBuilder()


class BatchGetOkrRequestBuilder(object):

    def __init__(self) -> None:
        batch_get_okr_request = BatchGetOkrRequest()
        batch_get_okr_request.http_method = HttpMethod.GET
        batch_get_okr_request.uri = "/open-apis/okr/v1/okrs/batch_get"
        batch_get_okr_request.token_types = {AccessTokenType.USER, AccessTokenType.TENANT}
        self._batch_get_okr_request: BatchGetOkrRequest = batch_get_okr_request

    def user_id_type(self, user_id_type: str) -> "BatchGetOkrRequestBuilder":
        self._batch_get_okr_request.user_id_type = user_id_type
        self._batch_get_okr_request.add_query("user_id_type", user_id_type)
        return self

    def okr_ids(self, okr_ids: List[str]) -> "BatchGetOkrRequestBuilder":
        self._batch_get_okr_request.okr_ids = okr_ids
        self._batch_get_okr_request.add_query("okr_ids", okr_ids)
        return self

    def lang(self, lang: str) -> "BatchGetOkrRequestBuilder":
        self._batch_get_okr_request.lang = lang
        self._batch_get_okr_request.add_query("lang", lang)
        return self

    def build(self) -> BatchGetOkrRequest:
        return self._batch_get_okr_request
