# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .content_gallery import ContentGallery
from .content_paragraph import ContentParagraph


class ContentBlockElement(object):
    _types = {
        "type": str,
        "paragraph": ContentParagraph,
        "gallery": ContentGallery,
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.paragraph: Optional[ContentParagraph] = None
        self.gallery: Optional[ContentGallery] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ContentBlockElementBuilder":
        return ContentBlockElementBuilder()


class ContentBlockElementBuilder(object):
    def __init__(self) -> None:
        self._content_block_element = ContentBlockElement()

    def type(self, type: str) -> "ContentBlockElementBuilder":
        self._content_block_element.type = type
        return self

    def paragraph(self, paragraph: ContentParagraph) -> "ContentBlockElementBuilder":
        self._content_block_element.paragraph = paragraph
        return self

    def gallery(self, gallery: ContentGallery) -> "ContentBlockElementBuilder":
        self._content_block_element.gallery = gallery
        return self

    def build(self) -> "ContentBlockElement":
        return self._content_block_element
