# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ContentImageItem(object):
    _types = {
        "file_token": str,
        "src": str,
        "width": float,
        "height": float,
    }

    def __init__(self, d=None):
        self.file_token: Optional[str] = None
        self.src: Optional[str] = None
        self.width: Optional[float] = None
        self.height: Optional[float] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ContentImageItemBuilder":
        return ContentImageItemBuilder()


class ContentImageItemBuilder(object):
    def __init__(self) -> None:
        self._content_image_item = ContentImageItem()

    def file_token(self, file_token: str) -> "ContentImageItemBuilder":
        self._content_image_item.file_token = file_token
        return self

    def src(self, src: str) -> "ContentImageItemBuilder":
        self._content_image_item.src = src
        return self

    def width(self, width: float) -> "ContentImageItemBuilder":
        self._content_image_item.width = width
        return self

    def height(self, height: float) -> "ContentImageItemBuilder":
        self._content_image_item.height = height
        return self

    def build(self) -> "ContentImageItem":
        return self._content_image_item
