# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .content_docs_link import ContentDocsLink
from .content_person import ContentPerson
from .content_text_run import ContentTextRun


class ContentParagraphElement(object):
    _types = {
        "type": str,
        "text_run": ContentTextRun,
        "docs_link": ContentDocsLink,
        "person": ContentPerson,
    }

    def __init__(self, d=None):
        self.type: Optional[str] = None
        self.text_run: Optional[ContentTextRun] = None
        self.docs_link: Optional[ContentDocsLink] = None
        self.person: Optional[ContentPerson] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ContentParagraphElementBuilder":
        return ContentParagraphElementBuilder()


class ContentParagraphElementBuilder(object):
    def __init__(self) -> None:
        self._content_paragraph_element = ContentParagraphElement()

    def type(self, type: str) -> "ContentParagraphElementBuilder":
        self._content_paragraph_element.type = type
        return self

    def text_run(self, text_run: ContentTextRun) -> "ContentParagraphElementBuilder":
        self._content_paragraph_element.text_run = text_run
        return self

    def docs_link(self, docs_link: ContentDocsLink) -> "ContentParagraphElementBuilder":
        self._content_paragraph_element.docs_link = docs_link
        return self

    def person(self, person: ContentPerson) -> "ContentParagraphElementBuilder":
        self._content_paragraph_element.person = person
        return self

    def build(self) -> "ContentParagraphElement":
        return self._content_paragraph_element
