# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_period_request_body import CreatePeriodRequestBody


class CreatePeriodRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[CreatePeriodRequestBody] = None

    @staticmethod
    def builder() -> "CreatePeriodRequestBuilder":
        return CreatePeriodRequestBuilder()


class CreatePeriodRequestBuilder(object):

    def __init__(self) -> None:
        create_period_request = CreatePeriodRequest()
        create_period_request.http_method = HttpMethod.POST
        create_period_request.uri = "/open-apis/okr/v1/periods"
        create_period_request.token_types = {AccessTokenType.TENANT}
        self._create_period_request: CreatePeriodRequest = create_period_request

    def request_body(self, request_body: CreatePeriodRequestBody) -> "CreatePeriodRequestBuilder":
        self._create_period_request.request_body = request_body
        self._create_period_request.body = request_body
        return self

    def build(self) -> CreatePeriodRequest:
        return self._create_period_request
