# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .create_progress_record_request_body import CreateProgressRecordRequestBody


class CreateProgressRecordRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.user_id_type: Optional[str] = None
        self.request_body: Optional[CreateProgressRecordRequestBody] = None

    @staticmethod
    def builder() -> "CreateProgressRecordRequestBuilder":
        return CreateProgressRecordRequestBuilder()


class CreateProgressRecordRequestBuilder(object):

    def __init__(self) -> None:
        create_progress_record_request = CreateProgressRecordRequest()
        create_progress_record_request.http_method = HttpMethod.POST
        create_progress_record_request.uri = "/open-apis/okr/v1/progress_records"
        create_progress_record_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._create_progress_record_request: CreateProgressRecordRequest = create_progress_record_request

    def user_id_type(self, user_id_type: str) -> "CreateProgressRecordRequestBuilder":
        self._create_progress_record_request.user_id_type = user_id_type
        self._create_progress_record_request.add_query("user_id_type", user_id_type)
        return self

    def request_body(self, request_body: CreateProgressRecordRequestBody) -> "CreateProgressRecordRequestBuilder":
        self._create_progress_record_request.request_body = request_body
        self._create_progress_record_request.body = request_body
        return self

    def build(self) -> CreateProgressRecordRequest:
        return self._create_progress_record_request
