# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .content_block import ContentBlock


class CreateProgressRecordRequestBody(object):
    _types = {
        "source_title": str,
        "source_url": str,
        "target_id": int,
        "target_type": int,
        "content": ContentBlock,
        "source_url_pc": str,
        "source_url_mobile": str,
    }

    def __init__(self, d=None):
        self.source_title: Optional[str] = None
        self.source_url: Optional[str] = None
        self.target_id: Optional[int] = None
        self.target_type: Optional[int] = None
        self.content: Optional[ContentBlock] = None
        self.source_url_pc: Optional[str] = None
        self.source_url_mobile: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CreateProgressRecordRequestBodyBuilder":
        return CreateProgressRecordRequestBodyBuilder()


class CreateProgressRecordRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._create_progress_record_request_body = CreateProgressRecordRequestBody()

    def source_title(self, source_title: str) -> "CreateProgressRecordRequestBodyBuilder":
        self._create_progress_record_request_body.source_title = source_title
        return self

    def source_url(self, source_url: str) -> "CreateProgressRecordRequestBodyBuilder":
        self._create_progress_record_request_body.source_url = source_url
        return self

    def target_id(self, target_id: int) -> "CreateProgressRecordRequestBodyBuilder":
        self._create_progress_record_request_body.target_id = target_id
        return self

    def target_type(self, target_type: int) -> "CreateProgressRecordRequestBodyBuilder":
        self._create_progress_record_request_body.target_type = target_type
        return self

    def content(self, content: ContentBlock) -> "CreateProgressRecordRequestBodyBuilder":
        self._create_progress_record_request_body.content = content
        return self

    def source_url_pc(self, source_url_pc: str) -> "CreateProgressRecordRequestBodyBuilder":
        self._create_progress_record_request_body.source_url_pc = source_url_pc
        return self

    def source_url_mobile(self, source_url_mobile: str) -> "CreateProgressRecordRequestBodyBuilder":
        self._create_progress_record_request_body.source_url_mobile = source_url_mobile
        return self

    def build(self) -> "CreateProgressRecordRequestBody":
        return self._create_progress_record_request_body
