# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .kr_content import KrContent


class Kr(object):
    _types = {
        "id": int,
        "pos": str,
        "score": str,
        "weight": str,
        "content": KrContent,
        "create_time": int,
        "modify_time": int,
    }

    def __init__(self, d=None):
        self.id: Optional[int] = None
        self.pos: Optional[str] = None
        self.score: Optional[str] = None
        self.weight: Optional[str] = None
        self.content: Optional[KrContent] = None
        self.create_time: Optional[int] = None
        self.modify_time: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "KrBuilder":
        return KrBuilder()


class KrBuilder(object):
    def __init__(self) -> None:
        self._kr = Kr()

    def id(self, id: int) -> "KrBuilder":
        self._kr.id = id
        return self

    def pos(self, pos: str) -> "KrBuilder":
        self._kr.pos = pos
        return self

    def score(self, score: str) -> "KrBuilder":
        self._kr.score = score
        return self

    def weight(self, weight: str) -> "KrBuilder":
        self._kr.weight = weight
        return self

    def content(self, content: KrContent) -> "KrBuilder":
        self._kr.content = content
        return self

    def create_time(self, create_time: int) -> "KrBuilder":
        self._kr.create_time = create_time
        return self

    def modify_time(self, modify_time: int) -> "KrBuilder":
        self._kr.modify_time = modify_time
        return self

    def build(self) -> "Kr":
        return self._kr
